CREATE TABLE [dbo].[FACT_BED_CLEAN_ETL](
	[CREATION_UTC_DATE] [datetime] NULL,
	[DIM_WARD_UID] [nvarchar](250) NULL,
	[DIM_BED_UID] [nvarchar](250) NULL,
	[DIM_DOMAIN_ID] [nvarchar](50) NULL,
	[MANUAL_REQUEST_CODE] [varchar](100) NULL,
	[ACCEPTED_DATE] [datetime] NULL,
	[ACCEPTED_BY] [nvarchar](250) NULL,
	[COMPLETED_DATE] [datetime] NULL,
	[COMPLETED_BY] [nvarchar](250) NULL,
	[SOURCE_ID] [int] NOT NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL,
	[LAST_EDITED_BY] [nvarchar](50) NULL,
	[LAST_EDIT_DATE] [datetime] NULL,
	[EMS_NOTIFY] [nvarchar](10) NULL,
	[REQUESTED_DATE] [datetime] NULL,
	[DIVISION_DIM_ORGANIZATION_UID] [nvarchar](250) NULL,
	[VISTA_SITE_DIM_ORGANIZATION_UID] [nvarchar](250) NULL,
	[COMMENT] [nvarchar](500) NULL,
	[COMMENTED_BY] [nvarchar](250) NULL,
	[COMMENTED_DATE] [datetime] NULL,
	[TYPE_OF_CLEAN_CODE] [varchar](100) NULL,
	[EVENT_IEN] [nvarchar](50) NULL,
	[VACATED_DATE] [datetime] NULL,
	[EVENT_TYPE] [nvarchar](3) NULL,
	[SPECIAL_INSTRUCTIONS] [nvarchar](500) NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Update bed clean table used by reports incremental job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_BED_CLEAN_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_DIM_BED_UID] ON [dbo].[FACT_BED_CLEAN_ETL] 
(
	[DIM_BED_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_DOMAIN_ID] ON [dbo].[FACT_BED_CLEAN_ETL] 
(
	[DIM_DOMAIN_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_WARD_UID] ON [dbo].[FACT_BED_CLEAN_ETL] 
(
	[DIM_WARD_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIVISION_DIM_ORGANIZATION_UID] ON [dbo].[FACT_BED_CLEAN_ETL] 
(
	[DIVISION_DIM_ORGANIZATION_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_MANUAL_REQUEST_CODE] ON [dbo].[FACT_BED_CLEAN_ETL] 
(
	[MANUAL_REQUEST_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[FACT_BED_CLEAN_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_TYPE_OF_CLEAN_CODE] ON [dbo].[FACT_BED_CLEAN_ETL] 
(
	[TYPE_OF_CLEAN_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_VISTA_SITE_DIM_ORGANIZATION_UID] ON [dbo].[FACT_BED_CLEAN_ETL] 
(
	[VISTA_SITE_DIM_ORGANIZATION_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO



